/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.interview.common.action;

import java.util.List;
import java.util.logging.Logger;
import oracle.install.commons.base.summary.Summary;
import oracle.install.commons.flow.DefaultAction;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.RoutePlan;
import oracle.install.commons.flow.State;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Graph;
import oracle.install.commons.util.XmlSupport;

public abstract class AbstractSummaryAction
extends DefaultAction {
    private static final Logger logger = Logger.getLogger(AbstractSummaryAction.class.getName());

    protected abstract void buildSummary(FlowContext var1);

    @Override
    public final void execute(FlowContext flowContext) {
        Summary summary = Summary.getInstance();
        summary.beginUpdate();
        this.buildSummary(flowContext);
        if (!summary.isReady()) {
            summary.endUpdate();
        }
        try {
            String text = XmlSupport.formatAsText(summary.toXML(), "/oracle/install/commons/base/summary/resource/summary_text.xsl");
            logger.info(text);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    @Override
    public final Route transition(FlowContext flowContext) {
        return Route.SUCCESS;
    }

    public final boolean isTraversableStateId(FlowContext flowContext, String stateId) {
        if (stateId != null && stateId.length() > 0 && Application.getInstance().getBoolean("wizard.visitedLinkEnabled", true)) {
            RoutePlan routePlan = flowContext.getRoutePlan();
            List<Graph<Route, State>> tracedPath = routePlan.getTracedPath();
            Object vertex = null;
            for (Graph<Route, State> node : tracedPath) {
                if (!node.getValue().getId().equals(stateId)) continue;
                return true;
            }
        }
        return false;
    }
}

